﻿uses GraphABC;

procedure DrawPythagorasGraph();
var
  x0, y0, scale: integer;
  
  // Функция: f(x) = x/2 + x/4 + x/7 + 3 - x
  function f(x: real): real;
  begin
    Result := x/2 + x/4 + x/7 + 3 - x;
  end;
  
  // Упрощенная функция: f(x) = 3 - 3x/28
  function f_simple(x: real): real;
  begin
    Result := 3 - (3*x)/28;
  end;
  
begin
  // Настройки окна
  Window.Title := ' Пифагорейское число граф';
  Window.SetSize(800, 500);
  Window.CenterOnScreen;
  
  // Фон
  Brush.Color := Color.White;
  FillRectangle(0, 0, Window.Width, Window.Height);
  
  // Начало координат и масштаб
  x0 := 100;    // Отступ слева
  y0 := 400;    // Нулевая линия по Y (f(x) = 0)
  scale := 8;   // Пикселей на единицу (учеников)
  
  // Рисуем ось X (количество учеников)
  Pen.Color := Color.Black;
  Pen.Width := 2;
  Line(50, y0, Window.Width - 50, y0);
  
  // Подписи на оси X
  for var i := 0 to 50 do
    if i mod 5 = 0 then
    begin
      var xpos := x0 + i * scale;
      // Отметки
      Line(xpos, y0 - 5, xpos, y0 + 5);
      // Числа
      if i = 28 then
      begin
        Font.Color := Color.Red;
        Font.Style := fsBold;
      end
      else
      begin
        Font.Color := Color.Black;
        Font.Style := fsNormal;
      end;
      TextOut(xpos - 8, y0 + 10, i.ToString);
    end;
  
  Font.Color := Color.Black;
  TextOut(Window.Width - 40, y0 + 10, 'x');
  TextOut(x0 + 200, y0 + 30, 'Количество учеников');
  
  // Рисуем ось Y (значения f(x))
  Line(x0, 50, x0, Window.Height - 50);
  
  // Подписи на оси Y
  for var i := -10 to 10 do
    if i mod 2 = 0 then
    begin
      var ypos := y0 - i * scale * 3;
      // Отметки
      Line(x0 - 5, ypos, x0 + 5, ypos);
      // Числа
      TextOut(x0 - 25, ypos - 8, i.ToString);
    end;
  TextOut(x0 - 20, 40, 'f(x)');
  
  // Рисуем прямую f(x) = 3 - 3x/28
  Pen.Color := Color.Blue;
  Pen.Width := 3;
  
  var first := true;
  for var i := 0 to 50 do
  begin
    var x := i;
    var y := f_simple(x);
    var xpos := x0 + x * scale;
    var ypos := y0 - Round(y * scale * 3); // Усиливаем масштаб по Y
    
    if first then
    begin
      MoveTo(xpos, ypos);
      first := false;
    end
    else
      LineTo(xpos, ypos);
  end;
  
  // Отмечаем корень уравнения f(x) = 0
  var root := 28;
  var y_root := f_simple(root); // = 0
  var xpos_root := x0 + root * scale;
  var ypos_root := y0 - Round(y_root * scale * 3);
  
  // Красная точка - решение
  Pen.Color := Color.Red;
  Pen.Width := 6;
  Circle(xpos_root, ypos_root, 8);
  
  // Вертикальная пунктирная линия к оси X
  Pen.Color := Color.Gray;
  Pen.Width := 1;
  Pen.Style := psDash;
  Line(xpos_root, ypos_root, xpos_root, y0);
  Pen.Style := psSolid;
  
  // Подпись корня
  Brush.Color := Color.White;
  Pen.Color := Color.Red;
  Font.Size := 12;
  Font.Style := fsBold;
  Font.Color := Color.Red;
  TextOut(xpos_root - 15, ypos_root - 30, 'x = 28');
  
  // Уравнение в углу
  Brush.Color := Color.LightYellow;
  FillRectangle(10, 10, 450, 100);
  Pen.Color := Color.Black;
  Rectangle(10, 10, 450, 100);
  
  Font.Size := 11;
  Font.Color := Color.Black;
  Font.Style := fsBold;
  TextOut(20, 15, 'Задача о школе Пифагора:');
  Font.Style := fsNormal;
  TextOut(20, 35, 'x/2 + x/4 + x/7 + 3 = x');
  TextOut(20, 55, 'После упрощения: 3 - 3x/28 = 0');
  TextOut(20, 75, 'Решение: x = 28 учеников');
  
  // Распределение учеников по группам
  Brush.Color := Color.LightCyan;
  FillRectangle(Window.Width - 400, 10, Window.Width - 10, 120);
  Pen.Color := Color.Black;
  Rectangle(Window.Width - 400, 10, Window.Width - 10, 120);
  
  Font.Size := 10;
  Font.Color := Color.Black;
  TextOut(Window.Width - 390, 15, 'Распределение 28 учеников:');
  TextOut(Window.Width - 390, 35, '• Изучают математику (1/2): 28/2 = 14');
  TextOut(Window.Width - 390, 50, '• Изучают музыку (1/4):     28/4 = 7');
  TextOut(Window.Width - 390, 65, '• Молчаливое размышление (1/7): 28/7 = 4');
  TextOut(Window.Width - 390, 80, '• Остальные:                   3');
  TextOut(Window.Width - 390, 100, 'Проверка суммы: 14 + 7 + 4 + 3 = 28 ✓');
  
  // Историческая справка
  Brush.Color := Color.LightGreen;
  FillRectangle(Window.Width - 400, 200, Window.Width - 10, 280);
  Pen.Color := Color.Black;
  Rectangle(Window.Width - 400, 200, Window.Width - 10, 280);
  
  TextOut(Window.Width - 390, 205, 'Историческая справка:');
  TextOut(Window.Width - 390, 225, 'Пифагор (570-495 до н.э.) - древнегреческий');
  TextOut(Window.Width - 390, 240, 'философ и математик, основатель школы');
  TextOut(Window.Width - 390, 255, 'пифагорейцев в Кротоне (Италия).');
  
  // Легенда графика
  Brush.Color := Color.White;
  FillRectangle(10, 120, 250, 180);
  Pen.Color := Color.Black;
  Rectangle(10, 120, 250, 200);
  
  TextOut(20, 125, 'Легенда графика:');
  Pen.Color := Color.Blue;
  Line(20, 145, 60, 145);
  TextOut(65, 140, 'f(x) = 3 - 3x/28');
  
  Pen.Color := Color.Red;
  Circle(40, 165, 4);
  TextOut(65, 160, 'Решение: f(28) = 0');
  
  Pen.Color := Color.Black;
  Line(20, 185, 60, 185);
  TextOut(65, 180, 'Ось X: f(x) = 0');
end;

begin
  DrawPythagorasGraph();
end.